# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data
electronics_ratings = np.random.normal(loc=4, scale=0.5, size=1000)
clothing_ratings = np.random.normal(loc=3.5, scale=0.7, size=1000)

# Define the number of bins and bin edges for consistent bin width
bins = np.histogram(np.hstack((electronics_ratings, clothing_ratings)), bins=15)[1]
labels = ["Electronics", "Clothing"]
xticks = [1, 2, 3, 4, 5]
xlabel = "Product Rating"
ylabel = "Count"
title = "Product Ratings in E-commerce"
legend_title = "Product Category"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 5))

# Create the histograms without stacking
plt.hist(
    electronics_ratings,
    bins=bins,
    color="#8B4513",  # SaddleBrown
    label=labels[0],
    edgecolor="white",
    linewidth=0.6,
    alpha=0.6,
    zorder=2,
)
plt.hist(
    clothing_ratings,
    bins=bins,
    color="#DAA520",  # GoldenRod
    label=labels[1],
    edgecolor="white",
    linewidth=0.6,
    alpha=0.6,
    zorder=3,
)

# Set the background color
plt.gca().set_facecolor("#FAF0E6")  # Linen

# Set the scale of y-axis to logarithmic
plt.yscale("log")

# Set the x-axis ticks
plt.xticks(xticks)
plt.tick_params(axis="x", length=0)

# Add white grid lines and place them behind the bars (zorder=0)
plt.grid(color="white", linestyle="-", linewidth=1.5, zorder=0)

# Set the y-axis ticks and remove all line markings (spines)
plt.yticks([1, 10, 100])
plt.tick_params(axis="y", length=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)  # Remove all the spines

# remove small dash on y-axis
plt.tick_params(axis="y", which="minor", length=0)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add legend with title
plt.legend(title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Show the plot
plt.savefig("hist_29.pdf", bbox_inches="tight")
