
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for personal finance
expenditure_essential = np.random.normal(1200, 300, 1000)  # Essential expenditure data
expenditure_non_essential = np.random.normal(500, 400, 1000)  # Non-essential expenditure data

# Define bins aligned for both histograms
bins = np.histogram(np.hstack((expenditure_essential, expenditure_non_essential)), bins=30)[1]
labels = ["Essential Items", "Non-Essential Items"]
xlabel = "Monthly Expenditure ($)"
ylabel = "Number of Individuals"
title = "Comparison of Monthly Expenditure"
legendlabels = ["Essential Items", "Non-Essential Items"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(
    figsize=(7, 5)
)  # Adjusted size for better visibility

# Plot data with optimized styles
ax.hist(
    expenditure_essential,
    bins=bins,
    color="#4CAF50",
    edgecolor="#2E7D32",
    linewidth=1.2,
    label=labels[0],
    align="mid",
    histtype="stepfilled",
    alpha=0.7,
)
ax.hist(
    expenditure_non_essential,
    bins=bins,
    color="#FFCC80",
    edgecolor="#EF6C00",
    linewidth=1.2,
    label=labels[1],
    align="mid",
    histtype="stepfilled",
    alpha=0.7,
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add legend
ax.legend(labels=legendlabels)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_32.pdf", bbox_inches="tight")
