# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate synthetic trading volume data (daily volume as a log-normal distribution)
data = np.random.lognormal(mean=12, sigma=1, size=10000)
data = data[
    data < 500000
]  # Limiting the data to a certain range for better visualization

xlabel = "Daily Trading Volume"
ylabel = "Frequency"
binslist = [50, 50]
mean_volume = np.mean(data)
median_volume = np.median(data)
title = "Distribution of Daily Trading Volume for Stock Index"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 4))

# Show grid with some transparency
plt.grid(True, linestyle="-", linewidth=0.5, color="#000000", alpha=0.1)

# Create the histogram
plt.hist(
    data, bins=binslist[0], color="#66c2a5", alpha=0.7, label="Volume Distribution"
)

# Create the histogram with histtype='step' for edge-only bars
plt.hist(
    data,
    bins=binslist[1],
    color="#66c2a5",
    edgecolor="#1b9e77",
    histtype="step",
    linewidth=1.2,
)

# Add a vertical line for the mean volume
plt.axvline(
    mean_volume, color="#fc8d62", linestyle="--", linewidth=1.5, label="Mean Volume"
)

# Set the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("hist_35.pdf", bbox_inches="tight")
