

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate data for psychological activities
mindfulness_meditation = np.random.exponential(scale=30, size=1000)
therapeutic_writing = np.random.exponential(scale=45, size=1000)
labels = ["Mindfulness Meditation", "Therapeutic Writing"]
xlabel = "Time Spent (minutes)"
ylabel = "Number of Participants"
title = "Distribution of Time Spent on Psychological Activities"
bins = 50

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to be more visually appealing for presentation
plt.figure(figsize=(10, 6))

# Plot histograms with stacked bars
plt.hist(
    [mindfulness_meditation, therapeutic_writing],
    bins=bins,
    stacked=True,
    label=labels,
    color=["#4CAF50", "#2196F3"],  # Green for mindfulness, blue for writing
    edgecolor="black",  # Add edge color for better distinction
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Adjust x-axis range to accommodate the new data and to add space at the beginning
plt.xlim(left=0, right=300)

# Optional: Add grid for better readability
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_37.pdf", bbox_inches="tight")

