

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(0)
engagement_levels = np.array([0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9])
understanding_rates = np.array([0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.4, 0.35, 0.5])
calibration_error = 0.15
text = f"Calibration Error:\n{calibration_error}"

# Axes Limits and Labels
xlabel_value = "Philosophical Engagement Level"
ylabel_value = "Understanding Rate"
title = "Philosophical Engagement vs Understanding Rates"
xlim_values = [0, 1]
ylim_values = [0, 1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 6))

# Plot histogram using plt.hist and specify bins
hist_color = "#ffcccb"
edge_color = "#ff6666"
line_color = "#6b8e23"
text_color = "#ff6347"

plt.hist(engagement_levels, bins=9, weights=understanding_rates, color=hist_color, edgecolor=edge_color)

# Add diagonal dashed line
plt.plot([0, 1], [0, 1], linestyle="--", linewidth=2, color=line_color)

# Add text for calibration error
plt.text(0.05, 0.9, text, color=text_color, fontsize=14)

# Set labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=16)

# Adjust x and y axis limits to match the reference picture
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_39.pdf", bbox_inches="tight")
