

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New Sample Data for Book Publications by Decade
decades = [1900, 1910, 1920, 1930, 1940, 1950, 1960, 1970, 1980, 1990, 2000, 2010]  # decade bins
books_published = [5_000, 10_000, 15_000, 20_000, 30_000, 50_000, 80_000, 120_000, 
                   200_000, 300_000, 500_000]  # books published in each decade

# Axes Limits and Labels
xlabel_value = "Decades"
ylabel_value = "Books Published"
title_value = "Book Publications by Decade"
xlim_values = [1900, 2010]
ylim_values = [0, 600_000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a histogram
plt.figure(figsize=(8, 6))  # Adjusted size for better visualization
plt.hist(decades[:-1], bins=decades, weights=books_published, color="#1f77b4", edgecolor='black', alpha=0.7)

# Set the labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value)

# Remove ticks on both axes
plt.tick_params(axis="both", which="both", length=0)

# Set the range for the axes
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("hist_42.pdf", bbox_inches="tight")

