
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data (replace with actual data)
age_groups = [10, 20, 30, 40, 50, 60, 70, 80, 90]
time_spent_on_social_media = [100, 180, 150, 120, 90, 60, 40, 30, 20]

# Axes Limits and Labels
xlabel_value = "Age Groups"
ylabel_value = "Average Time Spent on Social Media (minutes)"
xlim_values = [0, 100]
ylim_values = [0, 200]

# Chart title and additional text
chart_title = "Average Social Media Usage by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a histogram
# Color scheme
color_hist = "#4CAF50"
plt.figure(figsize=(8, 6))  # Adjusted for better visibility
plt.hist(age_groups, bins=9, weights=time_spent_on_social_media, color=color_hist, edgecolor='black', alpha=0.7)

# Set the labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(chart_title, fontsize=14, fontweight='bold')

# Remove ticks on both axes
plt.tick_params(axis="both", which="both", length=0)

# Set the range for the axes
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Grid for better readability
plt.grid(axis='y', linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("hist_44.pdf", bbox_inches="tight")
