

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample religion data
age_of_worshippers = np.random.normal(45, 15, 10000)  # Age of worshippers (Years)
weekly_service_attendance = np.random.binomial(10, 0.3, 10000)  # Weekly service attendance (Times per week)
binslist = [100, 10]
titles = ["Age of Worshippers", "Weekly Service Attendance"]
rangelist = [(0, 100), (0, 10)]
xlabel = "Value"
ylabel = ["Number of People", "Number of People"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(10, 7), gridspec_kw={"hspace": 0.3})

# First histogram: Age of Worshippers
axs[0].hist(age_of_worshippers, bins=binslist[0], range=rangelist[0], color="#4caf50")
axs[0].set_title(titles[0], fontsize=14, fontweight='bold')
axs[0].set_xlabel(xlabel, fontsize=12)
axs[0].set_ylabel(ylabel[0], fontsize=12)
axs[0].grid(True)

# Second histogram: Weekly Service Attendance
axs[1].hist(weekly_service_attendance, bins=binslist[1], range=rangelist[1], color="#2196f3")
axs[1].set_title(titles[1], fontsize=14, fontweight='bold')
axs[1].set_xlabel(xlabel, fontsize=12)
axs[1].set_ylabel(ylabel[1], fontsize=12)
axs[1].grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("hist_46.pdf", bbox_inches="tight")
