

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated data for insect populations (number of insects per region)
# Dataset for Species 1
insects_species1 = np.random.normal(500, 100, 10000)
# Dataset for Species 2
insects_species2 = np.random.normal(700, 120, 10000)
binslist = [50, 50]
titles = ["Species 1 Population", "Species 2 Population"]
rangelist = [(200, 800), (200, 1000)]
# Labels
xlabel = "Number of Insects"
ylabel = "Frequency"
suptitle = "Insect Population Data for Two Species"
legendlabels = ["Insects"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(10, 7), gridspec_kw={"hspace": 0.3})
# Colors
colors = ["#2a9d8f", "#e76f51"]

# First histogram (Species 1 Population)
axs[0].hist(insects_species1, bins=binslist[0], range=rangelist[0], color=colors[0])
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].legend(legendlabels, loc="upper right")

# Second histogram (Species 2 Population)
axs[1].hist(insects_species2, bins=binslist[1], range=rangelist[1], color=colors[1])
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].legend(legendlabels, loc="upper right")

# Set super title for the whole figure
fig.suptitle(suptitle)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95]) # Adjust layout to fit the suptitle
plt.savefig("hist_47.pdf", bbox_inches="tight")

