
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample test scores data
mid_term_math = np.random.normal(75, 10, 1000)
final_term_math = np.random.normal(78, 9, 1000)
mid_term_english = np.random.normal(70, 12, 1000)
final_term_english = np.random.normal(72, 11, 1000)

xlabel = "Test Scores"
ylabel = "Frequency"
binslist = [30, 30, 30, 30]
labels = ["Mid-Term Scores", "Final Scores"]
titles = ["Math Test Scores", "English Test Scores"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(12, 5))

# Left subplot for Math Test Scores
ax_left = plt.subplot(1, 2, 1)
plt.hist(
    mid_term_math,
    bins=binslist[0],
    alpha=0.6,
    label=labels[0],
    color="#e74c3c",
    zorder=2,
)
plt.hist(
    final_term_math,
    bins=binslist[1],
    alpha=0.6,
    label=labels[1],
    color="#2ecc71",
    zorder=3,
)
leg = plt.legend(frameon=False)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(titles[0])
plt.tick_params(axis="both", which="both", length=0)
plt.gca().set_facecolor("#f4f6f7")
plt.grid(True, color="white", zorder=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# Right subplot for English Test Scores
ax_right = plt.subplot(1, 2, 2)
plt.hist(
    mid_term_english,
    bins=binslist[2],
    alpha=0.6,
    label=labels[0],
    color="#e74c3c",
    zorder=2,
)
plt.hist(
    final_term_english,
    bins=binslist[3],
    alpha=0.6,
    label=labels[1],
    color="#2ecc71",
    zorder=3,
)
leg = plt.legend(frameon=False)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(titles[1])
plt.tick_params(axis="both", which="both", length=0)
plt.gca().set_facecolor("#f4f6f7")
plt.grid(True, color="white", zorder=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# Set axis spine colors to black
for ax in [ax_left, ax_right]:
    for spine in ax.spines.values():
        spine.set_edgecolor("black")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()

# Display the figure
plt.savefig("hist_48.pdf", bbox_inches="tight")
