
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate random data for financial domain
# Assuming data represents daily returns for two different stocks
stock_A_returns = np.random.normal(0.05, 0.02, 500)  # Daily returns for Stock A
stock_B_returns = np.random.normal(0.02, 0.015, 500)  # Daily returns for Stock B

# Labels and styles
labels = ["Stock A", "Stock B"]
xlabel = "Daily Return (%)"
ylabel = "Density"
titlelist = [
    "(a) Daily Returns of Stock A",
    "(b) Daily Returns of Stock B",
    "(c) Comparison in Q1",
    "(d) Comparison in Q2",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Additional style parameters
colors = ["#FF6347", "#4682B4"]
edgecolor = "black"
linewidth = 0.5

# Set figure size to match the original image's dimensions
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Plot histograms for each subplot
for i, ax in enumerate(axs.flatten()):
    ax.hist(
        stock_A_returns,
        bins=30,
        density=True,
        alpha=0.6,
        color=colors[0],
        label=labels[0],
        edgecolor=edgecolor,
        linewidth=linewidth,
    )
    ax.hist(
        stock_B_returns,
        bins=30,
        density=True,
        alpha=0.6,
        color=colors[1],
        label=labels[1],
        edgecolor=edgecolor,
        linewidth=linewidth,
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# Set titles for each subplot
axs[0, 0].set_title(titlelist[0])
axs[0, 1].set_title(titlelist[1])
axs[1, 0].set_title(titlelist[2])
axs[1, 1].set_title(titlelist[3])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_53.pdf", bbox_inches="tight")
