
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting a seed for reproducibility
np.random.seed(0)

# Simulating stress level data for two therapy groups over a year (365 days)
stress_group_a = np.random.normal(30, 10, 365)
stress_group_b = np.random.normal(20, 8, 365)

# Define bins aligned for both histograms with a little space between bars
bin_width = 5  # Adjust as necessary for clear separation
bins = np.histogram(np.hstack((stress_group_a, stress_group_b)), bins=20)[1]

# Labels and metadata for the plot
labels = ["Therapy A Stress Levels", "Therapy B Stress Levels"]
xlabel = "Stress Levels (0-100)"
ylabel = "Frequency"
title = "Stress Level Distribution Comparison: Therapy A vs Therapy B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust size if needed

# Plot histograms with custom colors
ax.hist(
    stress_group_a,
    bins=bins,
    alpha=0.7,
    label=labels[0],
    color="#1f77b4",  # Blue for Therapy A
    edgecolor="black",
    linestyle='-',  # Solid line
    linewidth=1.2
)
ax.hist(
    stress_group_b,
    bins=bins,
    alpha=0.7,
    label=labels[1],
    color="#ff7f0e",  # Orange for Therapy B
    edgecolor="black",
    linestyle=':',  # Dotted line
    linewidth=1.2
)

# Set labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Add title
ax.set_title(title)  # Adjust title to reflect the data

# Add grid
ax.grid(color="#d3d3d3", linestyle="-", linewidth=1, zorder=0)

# Add legend at a new location
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_60.pdf", bbox_inches="tight")
