

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data representing daily temperature measurements
data = np.random.normal(loc=22, scale=5, size=10000)

# Axes Limits and Labels
title = "Histogram of Daily Temperature Measurements"
xlabel_value = "Temperature (°C)"
ylabel_value = "Number of Days"
# Highlight the median of the data
median = np.median(data)
annotation_text = f"Median: {median:.2f} °C"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 7))

# Enable the grid
plt.grid(True, linestyle="--", linewidth=0.7, alpha=0.7)

# Histogram of the data
n, bins, patches = plt.hist(data, bins=30, color="forestgreen", edgecolor="darkgreen", alpha=0.75)

plt.axvline(median, color="darkred", linestyle="dashed", linewidth=2)

# Adjust the median text position to not overlap the bars when possible
median_text_position = max(n) * 0.9
for bin_edge, count in zip(bins, n):
    if bin_edge > median and count < median_text_position:
        # Place the text above the median position
        median_text_position = count
        break
plt.text(median + 0.5, median_text_position, annotation_text, color="darkred", fontsize=12, fontweight='bold')

# Title and labels relevant to temperature measurements
plt.title(title, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout
plt.tight_layout()

plt.savefig("hist_64.pdf", bbox_inches="tight")

