

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for Publication Years of Philosophical Works
modern_works_years = np.random.normal(loc=1950, scale=20, size=1000)
classical_works_years = np.random.normal(loc=1750, scale=30, size=1000)

# Labels and Plot Types
hist_label = ["Modern Philosophical Works", "Classical Philosophical Works"]

# Axes Limits and Labels
xlabel_value = "Publication Years"
ylabel_value = "Frequency"
title = "Publication Years of Philosophical Works"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 5))

# Plot histograms with stacked bars, modified colors, and alpha for transparency
plt.hist(
    [modern_works_years, classical_works_years],
    bins=40,
    stacked=True,
    label=hist_label,
    color=["#2E8B57", "#1E90FF"],
    alpha=0.7,
)

# Add labels, title, and modify the style of the labels
plt.xlabel(xlabel_value, fontsize=12, color="#000000")
plt.ylabel(ylabel_value, fontsize=12, color="#000000")
plt.title(title, fontsize=14, fontweight='bold', color="#000000")

# Modify the legend style and position to upper right
plt.legend(frameon=True, loc="upper right", fontsize=10)

# Adjust x-axis range and add some space at the beginning of the x-axis
plt.xlim(left=1600, right=2100)  # Adjusted xlim for better visualization

# Add grid with lighter color and set behind the histograms
plt.grid(color="grey", linestyle="--", linewidth=0.5, alpha=0.7)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_66.pdf", bbox_inches="tight")

