
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for economic metrics
employment_rate = np.random.normal(loc=5, scale=1, size=1000)
inflation_rate = np.random.normal(loc=2.5, scale=0.5, size=1000)

# Labels and Plot Types
hist_label = ["Employment Rate", "Inflation Rate"]

# Axes Limits and Labels
xlabel_value = "Rate (%)"
ylabel_value = "Frequency"
title = "Economic Metrics Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(8, 6))

# Colors for plot
colors = ["#1E90FF", "#228B22"]

# Plot histograms with stacked bars, modified colors, and alpha for transparency
plt.hist(
    [employment_rate, inflation_rate],
    bins=30,
    stacked=True,
    label=hist_label,
    color=colors,
    alpha=0.7,
)

# Add labels, title, and modify the style of the labels
plt.xlabel(xlabel_value, color="#333333")
plt.ylabel(ylabel_value, color="#333333")
plt.title(title)

# Modify the legend style and position to lower right
plt.legend(frameon=True, loc="upper right")

# Adjust x-axis range and add some space at the beginning of the x-axis
plt.xlim(left=plt.xlim()[0], right=10) 

# Add grid with lighter color and set behind the histograms
plt.grid(color="grey", linestyle="--", linewidth=0.5, alpha=0.7)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_67.pdf", bbox_inches="tight")
