

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating data for points scored by different teams in a season
sizes = np.linspace(30, 20, 6, dtype=int)  # Generate sizes from 30 to 20
data = [np.abs(np.random.normal(100, 15, size)) for size in sizes]  # Generate data

labels = ["Team A", "Team B", "Team C", "Team D", "Team E", "Team F"]

# Adjusting the data and labels for the second histogram
# Simulating data for points allowed by different teams in a season
modified_sizes = np.linspace(30, 25, 6, dtype=int)  # Generate sizes from 30 to 25
modified_data = [
    np.abs(np.random.normal(105, 10, size)) for size in modified_sizes
]  # Generate data with different mean and variance

modified_labels = ["Def. " + label for label in labels]  # Prepend 'Def. ' to each label

# Text labels and other parameters
xlabels = ["Points Scored in a Season", "Points Allowed in a Season"]
ylabels = ["Frequency", "Frequency"]
xlims = [[50, 150], [50, 150]]
xticks = [[50, 70, 90, 110, 130, 150], [50, 70, 90, 110, 130, 150]]
binslist = [15, 15]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1 x 2 subplot for the updated plots
fig, axs = plt.subplots(nrows=1, ncols=2, figsize=(16, 7))

# Custom colors for the energy domain (retained as per the requirement)
colors = ["#FFA07A", "#20B2AA", "#778899", "#FFD700", "#8B0000", "#00CED1"]

# First subplot (Points Scored)
axs[0].hist(
    data,
    bins=binslist[0],
    stacked=True,
    edgecolor="black",
    linewidth=1.2,
    color=colors,
    label=labels,
)
axs[0].set_xlabel(xlabels[0])
axs[0].set_ylabel(ylabels[0])
axs[0].set_xlim(xlims[0])
axs[0].set_xticks(xticks[0])
axs[0].set_facecolor("white")
handles, labels = axs[0].get_legend_handles_labels()
handles = handles[::-1]
labels = labels[::-1]
axs[0].legend(handles, labels, loc="upper right")

# Second subplot (Points Allowed)
axs[1].hist(
    modified_data,
    bins=binslist[1],
    stacked=True,
    edgecolor="black",
    linewidth=1.2,
    color=colors,
    label=modified_labels,
)
axs[1].set_xlabel(xlabels[1])
axs[1].set_ylabel(ylabels[1])
axs[1].set_xlim(xlims[1])
axs[1].set_xticks(xticks[1])
axs[1].set_facecolor("white")
handles, labels = axs[1].get_legend_handles_labels()
handles = handles[::-1]
labels = labels[::-1]
axs[1].legend(handles, labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("hist_69.pdf", bbox_inches="tight")

