

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating data for fitness activities time spent
sizes = np.linspace(300, 100, 6, dtype=int)  # Generate sizes from 300 to 100
data = [
    np.abs(np.random.normal(30, 10, size)) for size in sizes
]  # Generate data with mean 30 and std deviation 10

labels = [
    "Running",
    "Cycling",
    "Swimming",
    "Yoga",
    "Weight Lifting",
    "CrossFit",
]

# Adjusting the data and labels for the second histogram with slightly different mean and variance
modified_sizes = np.linspace(300, 200, 6, dtype=int)  # Generate sizes from 300 to 200
modified_data = [
    np.abs(np.random.normal(35, 12, size)) for size in modified_sizes
]  # Mean 35 and std deviation 12

modified_labels = [
    "Modified " + label for label in labels
]  # Prepend 'Modified ' to each original label

# Axis titles and labels
xlabels = ["Time Spent (minutes)", "Time Spent (minutes)"]
ylabels = ["Number of Participants", "Number of Participants"]
xlims = [[0, 100], [0, 100]]
xticks = [[0, 20, 40, 60, 80, 100], [0, 20, 40, 60, 80, 100]]
binslist = [30, 30]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1 x 2 subplot for plotting
fig, axs = plt.subplots(nrows=1, ncols=2, figsize=(16, 7))

# Color scheme
colors = ["#8ecae6", "#219ebc", "#023047", "#ffb703", "#fb8500", "#ff595e"]

# First subplot (original data)
axs[0].hist(
    data,
    bins=binslist[0],
    stacked=True,
    edgecolor="white",
    linewidth=1.2,
    color=colors,
    label=labels,
)
axs[0].set_xlabel(xlabels[0])
axs[0].set_ylabel(ylabels[0])
axs[0].set_xlim(xlims[0])
axs[0].set_xticks(xticks[0])
axs[0].set_facecolor("white")
handles, labels = axs[0].get_legend_handles_labels()
handles = handles[::-1]
labels = labels[::-1]
axs[0].legend(handles, labels, loc="upper right")

# Second subplot (modified data)
axs[1].hist(
    modified_data,
    bins=binslist[1],
    stacked=True,
    edgecolor="white",
    linewidth=1.2,
    color=colors,
    label=modified_labels,
)
axs[1].set_xlabel(xlabels[1])
axs[1].set_ylabel(ylabels[1])
axs[1].set_xlim(xlims[1])
axs[1].set_xticks(xticks[1])
axs[1].set_facecolor("white")
handles, labels = axs[1].get_legend_handles_labels()
handles = handles[::-1]
labels = labels[::-1]
axs[1].legend(handles, labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("hist_71.pdf", bbox_inches="tight")

