
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Simulated psychological well-being scores (out of 100) for weekends and weekdays
wellbeing_data_weekends = np.random.normal(75, 10, 10000)
wellbeing_data_weekdays = np.random.normal(60, 12, 10000)

suptitle = "Psychological Well-being Scores Distribution"
binslist = [50, 50]
titles = ["Well-being Scores on Weekends", "Well-being Scores on Weekdays"]
labels = ["Weekends", "Weekdays"]
ranges = (20, 100)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(12, 8), gridspec_kw={"hspace": 0.5})

# Overall title (suptitle)
fig.suptitle(suptitle)

# Colors
color_weekends_concerts = "#6a0dad"
color_weekdays_concerts = "#ff69b4"
color_weekends_movies = "#1e90ff"
color_weekdays_movies = "#ff4500"

# First histogram (Well-being Scores on Weekends)
n, bins, patches = axs[0].hist(
    wellbeing_data_weekends, bins=binslist[0], range=ranges, alpha=0.75, label=labels[0], color=color_weekends_concerts
)
axs[0].hist(wellbeing_data_weekdays, bins=bins, alpha=0.75, label=labels[1], color=color_weekdays_concerts)
axs[0].set_title(titles[0])
axs[0].grid(True)  # Adding grid
axs[0].legend()  # Adding legend

# Second histogram (Well-being Scores on Weekdays)
axs[1].hist(
    wellbeing_data_weekends,
    bins=binslist[1],
    range=ranges,
    alpha=0.75,
    label=labels[0],
    color=color_weekends_movies,
)
axs[1].hist(wellbeing_data_weekdays, bins=bins, alpha=0.75, label=labels[1], color=color_weekdays_movies)
axs[1].set_title(titles[1])
axs[1].grid(True)  # Adding grid
axs[1].legend()  # Adding legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(
    rect=[0, 0.03, 1, 0.95]
)  # Adjust the layout to accommodate the overall title

plt.savefig("hist_75.pdf", bbox_inches="tight")
