
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate random bimodal data representing vehicular speeds in different environments
data1_urban = np.concatenate(
    [np.random.normal(40, 15, 700), np.random.normal(25, 10, 300)]
)
data2_urban = np.concatenate(
    [np.random.normal(50, 12, 500), np.random.normal(35, 8, 500)]
)

data1_rural = np.concatenate(
    [np.random.normal(60, 10, 600), np.random.normal(70, 12, 400)]
)
data2_rural = np.concatenate(
    [np.random.normal(55, 15, 700), np.random.normal(65, 10, 300)]
)

data1_suburban = np.concatenate(
    [np.random.normal(50, 12, 500), np.random.normal(35, 10, 500)]
)
data2_suburban = np.concatenate(
    [np.random.normal(45, 14, 700), np.random.normal(40, 8, 300)]
)

data1_metro = np.concatenate(
    [np.random.normal(30, 8, 400), np.random.normal(20, 6, 600)]
)
data2_metro = np.concatenate(
    [np.random.normal(25, 10, 500), np.random.normal(15, 5, 500)]
)

binslist = [25, 25]
labels = ["Morning Traffic", "Evening Traffic"]
xlabel = "Speed (km/h)"
ylabel = "Density"
titles = [
    "(a) Urban Area Speeds",
    "(b) Rural Area Speeds",
    "(c) Suburban Area Speeds",
    "(d) Metropolitan Area Speeds",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Plot histograms for each subplot
datasets = [
    (data1_urban, data2_urban),
    (data1_rural, data2_rural),
    (data1_suburban, data2_suburban),
    (data1_metro, data2_metro),
]
for (data1, data2), ax in zip(datasets, axs.flatten()):
    ax.hist(
        data1,
        bins=binslist[0],
        density=True,
        alpha=0.6,
        color="#1f77b4",  # Blue for Morning Traffic
        label=labels[0],
        edgecolor="black",
        linewidth=0.5,
    )
    ax.hist(
        data2,
        bins=binslist[1],
        density=True,
        alpha=0.6,
        color="#ff7f0e",  # Red for Evening Traffic
        label=labels[1],
        edgecolor="black",
        linewidth=0.5,
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True, linestyle='--', alpha=0.7)
    ax.legend()

# Set titles for each subplot
axs[0, 0].set_title(titles[0])
axs[0, 1].set_title(titles[1])
axs[1, 0].set_title(titles[2])
axs[1, 1].set_title(titles[3])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("hist_80.pdf", bbox_inches="tight")
