

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated population growth data for five regions over 5 years
years = [1, 2, 3, 4, 5]
region_A = [2.5, 2.7, 3.0, 3.2, 3.5]
region_B = [1.8, 2.0, 2.2, 2.5, 2.8]
region_C = [2.0, 2.2, 2.5, 2.7, 3.0]
region_D = [1.5, 1.7, 2.0, 2.2, 2.5]
average_population_line_y = [2.2, 2.2]
average_population_line_x = [0, 6]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [0, 6]

ylabel_value = "Population (in millions)"
ylim_values = [1.0, 3.6]
yticks_values = [1.5, 2.0, 2.5, 3.0, 3.5]

# Labels
label_A = "Region A"
label_B = "Region B"
label_C = "Region C"
label_D = "Region D"
label_avg = "Average Population"

# Titles
title_1 = "Yearly Population Growth"
title_2 = "Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 6))  # Adjust figure size for better readability
plt.plot(years, region_A, label=label_A, color="#1f77b4", marker="o", linestyle="-", linewidth=2)
plt.plot(years, region_B, label=label_B, color="#ff7f0e", marker="s", linestyle="--", linewidth=2)
plt.plot(years, region_C, label=label_C, color="#2ca02c", marker="^", linestyle="-.", linewidth=2)
plt.plot(years, region_D, label=label_D, color="#9467bd", marker="d", linestyle=":", linewidth=2)
plt.plot(average_population_line_x, average_population_line_y, label=label_avg, color="black", linestyle="--", linewidth=1)

# Add title and labels
plt.title(title_1)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(years)
plt.xlim(xlim_values)
plt.yticks(yticks_values)
plt.ylim(ylim_values)
# Add legend with additional entry
plt.legend(title=title_2, loc="upper left")

# Adding a grid with slight modifications
plt.grid(color="grey", linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_101.pdf", bbox_inches="tight")

