
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Simulated data for student performance over study hours
study_hours = np.array([0, 2, 4, 6, 8, 10])
performance_traditional = np.array([50, 55, 60, 65, 70, 75])  # Traditional Study Performance
performance_online = np.array([52, 58, 63, 67, 72, 76])  # Online Courses Performance
performance_group = np.array([48, 54, 59, 64, 69, 73])  # Group Study Performance

# Reference Line for Ideal Performance
ideal_performance_y = [80, 80]
ideal_performance_x = [-1, 11]

# Axes Limits and Labels
xlabel_value = "Study Hours"
xlim_values = [-1, 11]

ylabel_value = "Performance Score"
ylim_values = [45, 80]
yticks_values = [50, 55, 60, 65, 70, 75, 80]

# Labels
label_1 = "Traditional Study"
label_2 = "Online Courses"
label_3 = "Group Study"
label_4 = "Ideal Performance"

# Titles
title_1 = "Performance Score over Study Hours for Different Methods"
title_2 = "Study Methods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 6))  # Adjust figure size to match a professional look
plt.plot(study_hours, performance_traditional, label=label_1, color="#1f77b4", marker="o", linestyle="-", linewidth=2)
plt.plot(study_hours, performance_online, label=label_2, color="#ff7f0e", marker="s", linestyle="--", linewidth=2)
plt.plot(study_hours, performance_group, label=label_3, color="#2ca02c", marker="^", linestyle=":", linewidth=2)
plt.plot(ideal_performance_x, ideal_performance_y, label=label_4, color="#d62728", linestyle="--", linewidth=1.5)

# Add title and labels
plt.title(title_1, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.xticks(study_hours)
plt.xlim(xlim_values)
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Add legend with additional entry
plt.legend(title=title_2,loc="upper right")

# Adding a grid with a slightly gray color
plt.grid(color="#e5e5e5", linestyle="-", linewidth=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_102.pdf", bbox_inches="tight")
