# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New data for historical trends
time_periods = [1850, 1875, 1900, 1925, 1950]
industry_advancements = [10, 30, 60, 90, 110]
economic_growth = [50, 55, 70, 40, 60]
military_expansions = [5, 20, 40, 60, 80]
peace_periods = [80, 60, 50, 30, 20]
threshold = [0, 120]
threshold_time = [1840, 1960]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1840, 1960]

ylabel_value = "Index Value"
ylim_values = [0, 120]
yticks_values = [0, 30, 60, 90, 120]

# Labels
label_industry = "Industrial Advancements"
label_economic = "Economic Growth"
label_military = "Military Expansions"
label_peace = "Peace Periods"
label_threshold = "Steady Growth Threshold"

# Titles
title_1 = "Historical Trends Over Time"
title_2 = "Factors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 6))  # Adjust figure size
# Plot with different line styles and marker shapes
plt.plot(
    time_periods,
    industry_advancements,
    label=label_industry,
    color="#3b5998",
    marker="o",
    linewidth=2,
)
plt.plot(
    time_periods,
    economic_growth,
    label=label_economic,
    color="#1da1f2",
    marker="s",
    linestyle="--",
    linewidth=2,
)
plt.plot(
    time_periods,
    military_expansions,
    label=label_military,
    color="#e4405f",
    marker="^",
    linestyle=":",
    linewidth=2,
)
plt.plot(
    time_periods,
    peace_periods,
    label=label_peace,
    color="#fffc00",
    marker="d",
    linestyle="-.",
    linewidth=2,
)
# Threshold line
plt.plot(
    threshold_time, threshold, label=label_threshold, color="black", linestyle="--"
)

# Add title and labels
plt.title(title_1)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(time_periods)
plt.xlim(xlim_values)
plt.yticks(yticks_values)
plt.ylim(ylim_values)
# Add legend with additional entry
plt.legend(title=title_2, loc="upper left")

# Adding the white grid manually
plt.grid(color="#e0e0e0", linestyle="-", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_103.pdf", bbox_inches="tight")
