
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated tourism data
years = [2018, 2019, 2020, 2021, 2022]
international_tourists = [80, 85, 50, 70, 90]  # Millions of international tourists
domestic_expenditure = [150, 160, 140, 155, 170]  # Domestic tourism expenditure in billions
hotel_occupancy_rate = [75, 78, 60, 65, 80]  # Hotel occupancy rates in percentage

# Extracted variables
line_label_international = "International Tourists (Millions)"
line_label_domestic = "Domestic Tourism Expenditure (Billions)"
line_label_occupancy = "Hotel Occupancy Rate (%)"
xlim_values = (2018, 2022)
ylim_values = (0, 200)
xlabel_value = "Year"
ylabel_value = "Value"
xticks_values = years
yticks_values = None  # Not explicitly set

# Labels and other textual elements
xtickslabel_fontsize = 14
ytickslabel_fontsize = 14
title_value = "Tourism Indicators Over Years"
axhline_value = None  # Not explicitly set in the code
axvline_value = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting the lines with enhanced styles
plt.figure(figsize=(10, 6))
plt.plot(
    years,
    international_tourists,
    marker="o",
    markersize=8,
    linestyle="-.",
    linewidth=2,
    color="#1f77b4",
    label=line_label_international,
    clip_on=False,
    zorder=10,
)
plt.plot(
    years,
    domestic_expenditure,
    marker="s",
    markerfacecolor="white",
    markersize=8,
    linestyle="--",
    linewidth=2,
    markeredgecolor="#ff7f0e",
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    label=line_label_domestic,
)
plt.plot(
    years,
    hotel_occupancy_rate,
    marker="^",
    markerfacecolor="white",
    markersize=8,
    linestyle="-",
    linewidth=2,
    markeredgecolor="#2ca02c",
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    label=line_label_occupancy,
)

# Setting the x-axis and y-axis limits
plt.ylim(*ylim_values)
plt.yticks(fontsize=ytickslabel_fontsize)
plt.xlim(*xlim_values)
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)

# Adding labels, title, and legend
plt.xlabel(xlabel_value, fontsize=18)
plt.ylabel(ylabel_value, fontsize=18)
plt.title(title_value, fontsize=20, pad=20)

# Adding legend with increased font size
plt.legend(
    fontsize="large",
    loc="upper left",
    frameon=False,
)

# Adding grid
plt.grid(True, alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_104.pdf", bbox_inches="tight")
