
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Variable extraction
line_label_site_a = "Observation Site A"
line_label_site_b = "Observation Site B"
xlim_values = (0, 200)
ylim_values_brightness = (0, 10)
ylim_values_temperature = (3000, 10000)
ylim_values_density = (0, 20)
ylim_values_pollution = (10, 25)
xlabel_value = "Observation Days"
ylabel_value_brightness = "Brightness (mag)"
ylabel_value_temperature = "Temperature (K)"
ylabel_value_density = "Density (objects/arcmin²)"
ylabel_value_pollution = "Light Pollution (mag/arcsec²)"
yticks_values_brightness = [0, 2, 4, 6, 8, 10]
yticks_values_temperature = [3000, 4500, 6000, 7500, 9000, 10000]
yticks_values_density = [0, 5, 10, 15, 20]
yticks_values_pollution = [10, 13, 16, 19, 22, 25]

# Generate new data for astronomical observations
# Brightness of Stars
iterations = np.linspace(0, 200, 21)
brightness_site_a = np.random.normal(loc=5, scale=1, size=len(iterations))
brightness_site_b = np.random.normal(loc=6, scale=1.5, size=len(iterations))

# Visible Temperature
temperature_site_a = np.random.normal(loc=6000, scale=1000, size=len(iterations))
temperature_site_b = np.random.normal(loc=5500, scale=800, size=len(iterations))

# Celestial Object Density
density_site_a = np.random.normal(loc=10, scale=2, size=len(iterations))
density_site_b = np.random.normal(loc=12, scale=3, size=len(iterations))

# Light Pollution Levels
pollution_site_a = np.random.normal(loc=15, scale=2, size=len(iterations))
pollution_site_b = np.random.normal(loc=18, scale=1.5, size=len(iterations))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.2)
legend_frameon = False
legend_ncol = 2
grid_value = True

# Create subplots
fig, axs = plt.subplots(4, 1, figsize=(8, 10))

# Plotting Brightness of Stars
axs[0].plot(iterations, brightness_site_a, label=line_label_site_a, color="darkgreen", linestyle="--", marker="o")
axs[0].plot(iterations, brightness_site_b, label=line_label_site_b, color="limegreen", linestyle=":", marker="s")
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_brightness)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_brightness)
axs[0].set_yticks(yticks_values_brightness)
axs[0].tick_params(axis="both", which="both", color="gray")

# Plotting Visible Temperature
axs[1].plot(iterations, temperature_site_a, label=line_label_site_a, color="red", linestyle="--", marker="x")
axs[1].plot(iterations, temperature_site_b, label=line_label_site_b, color="orangered", linestyle="-.", marker="d")
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_temperature)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_temperature)
axs[1].set_yticks(yticks_values_temperature)
axs[1].tick_params(axis="both", which="both", color="gray")

# Plotting Celestial Object Density
axs[2].plot(iterations, density_site_a, label=line_label_site_a, color="blue", linestyle="-", marker="<")
axs[2].plot(iterations, density_site_b, label=line_label_site_b, color="dodgerblue", linestyle="--", marker=">")
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_density)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_density)
axs[2].set_yticks(yticks_values_density)
axs[2].tick_params(axis="both", which="both", color="gray")

# Plotting Light Pollution Levels
axs[3].plot(iterations, pollution_site_a, label=line_label_site_a, color="goldenrod", linestyle="-.", marker="h")
axs[3].plot(iterations, pollution_site_b, label=line_label_site_b, color="gold", linestyle="--", marker="*")
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_pollution)
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_pollution)
axs[3].set_yticks(yticks_values_pollution)
axs[3].tick_params(axis="both", which="both", color="gray")

# Add legends and gridlines to each subplot
for ax in axs.flat:
    ax.legend(
        loc=legend_location,
        bbox_to_anchor=legend_bbox_to_anchor,
        frameon=legend_frameon,
        ncol=legend_ncol,
    )
    ax.grid(grid_value)  # Enable the grid

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("line_107.pdf", bbox_inches="tight")
