
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Variable extraction
line_label_base = "Baseline"
line_label_ours = "Our Model"
xlim_values = (0, 100)
ylim_values_population_growth = (0, 20)
ylim_values_birth_rate = (5, 40)
ylim_values_death_rate = (0, 20)
ylim_values_life_expectancy = (50, 90)
xlabel_value = "Years"
ylabel_value_population_growth = "Population Growth (in Millions)"
ylabel_value_birth_rate = "Birth Rate (per 1,000 People)"
ylabel_value_death_rate = "Death Rate (per 1,000 People)"
ylabel_value_life_expectancy = "Life Expectancy (Years)"
yticks_values_population_growth = np.arange(0, 21, 5)
yticks_values_birth_rate = np.arange(5, 41, 5)
yticks_values_death_rate = np.arange(0, 21, 5)
yticks_values_life_expectancy = np.arange(50, 91, 10)

# Population Growth
years = np.linspace(0, 100, 21)
base_data_population_growth = np.random.uniform(5, 10, len(years))
ours_data_population_growth = np.random.uniform(10, 15, len(years))

# Birth Rate
base_data_birth_rate = np.random.uniform(15, 20, len(years))
ours_data_birth_rate = np.random.uniform(25, 30, len(years))

# Death Rate
base_data_death_rate = np.random.uniform(5, 10, len(years))
ours_data_death_rate = np.random.uniform(10, 15, len(years))

# Life Expectancy
base_data_life_expectancy = np.random.uniform(60, 70, len(years))
ours_data_life_expectancy = np.random.uniform(70, 80, len(years))

# Chart style parameters
legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_frameon = False
legend_ncol = 2
grid_value = True

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create subplots
fig, axs = plt.subplots(4, 1, figsize=(8, 12))

# Define colors
colors = ['#2ca02c', '#d62728']

# Plotting Population Growth
axs[0].plot(years, base_data_population_growth, label=line_label_base, color=colors[0], linestyle='--', linewidth=1.5, marker='o')
axs[0].plot(years, ours_data_population_growth, label=line_label_ours, color=colors[1], linestyle='-', linewidth=1.5, marker='x')
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_population_growth)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_population_growth)
axs[0].set_yticks(yticks_values_population_growth)
axs[0].tick_params(axis="both", which="both", color="gray")

# Plotting Birth Rate
axs[1].plot(years, base_data_birth_rate, label=line_label_base, color=colors[0], linestyle='--', linewidth=1.5, marker='o')
axs[1].plot(years, ours_data_birth_rate, label=line_label_ours, color=colors[1], linestyle='-', linewidth=1.5, marker='x')
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_birth_rate)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_birth_rate)
axs[1].set_yticks(yticks_values_birth_rate)
axs[1].tick_params(axis="both", which="both", color="gray")

# Plotting Death Rate
axs[2].plot(years, base_data_death_rate, label=line_label_base, color=colors[0], linestyle='--', linewidth=1.5, marker='o')
axs[2].plot(years, ours_data_death_rate, label=line_label_ours, color=colors[1], linestyle='-', linewidth=1.5, marker='x')
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_death_rate)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_death_rate)
axs[2].set_yticks(yticks_values_death_rate)
axs[2].tick_params(axis="both", which="both", color="gray")

# Plotting Life Expectancy
axs[3].plot(years, base_data_life_expectancy, label=line_label_base, color=colors[0], linestyle='--', linewidth=1.5, marker='o')
axs[3].plot(years, ours_data_life_expectancy, label=line_label_ours, color=colors[1], linestyle='-', linewidth=1.5, marker='x')
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_life_expectancy)
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_life_expectancy)
axs[3].set_yticks(yticks_values_life_expectancy)
axs[3].tick_params(axis="both", which="both", color="gray")

# Add legends and gridlines to each subplot
for ax in axs.flat:
    ax.legend(
        loc=legend_location,
        bbox_to_anchor=legend_bbox_to_anchor,
        frameon=legend_frameon,
        ncol=legend_ncol,
    )
    ax.grid(grid_value)  # Enable the grid

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("line_108.pdf", bbox_inches="tight")
