

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
months = list(range(1, 13))
city_a_temp = np.cumsum(np.random.normal(loc=2, scale=1, size=len(months))) + 10
city_b_temp = np.cumsum(np.random.normal(loc=1, scale=1.5, size=len(months))) + 5

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [1, 12]

ylabel_value = "Average Temperature (°C)"
ylim_values = [0, max(np.max(city_a_temp), np.max(city_b_temp)) + 5]
yticks_values = np.arange(0, max(np.max(city_a_temp), np.max(city_b_temp)) + 5, 5)

axvspan1_l, axvspan1_r = 5, 8
axvspan2_l, axvspan2_r = 9, 12

# Labels
label_1 = "City A"
label_2 = "City B"

# Annotations
annotation_1 = "Summer\nPeak"
annotation_2 = "Winter\nDip"
title = "Average Monthly Temperature Trends of Two Cities Over a Year"
suptitle = "Environmental Data Visualization"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(months, city_a_temp, "g-^", label=label_1, linestyle="solid", linewidth=2, markersize=8)
ax.plot(months, city_b_temp, "b-o", label=label_2, linestyle="dashed", linewidth=2, markersize=6)

# Highlight specific regions
ax.axvspan(axvspan1_l, axvspan1_r, color="lightgreen", alpha=0.3)
ax.axvspan(axvspan2_l, axvspan2_r, color="lightblue", alpha=0.3)

# Annotations
ax.annotate(
    annotation_1,
    xy=(6, city_a_temp[5]),
    xytext=(7, city_a_temp[5] + 5),
    arrowprops=dict(facecolor="green", shrink=0.05),
)
ax.annotate(
    annotation_2,
    xy=(10, city_b_temp[9]),
    xytext=(11, city_b_temp[9] + 5),
    arrowprops=dict(facecolor="blue", shrink=0.05),
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xticks(months)
ax.set_xlim(xlim_values)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
fig.suptitle(suptitle, fontsize=14)

# Add legend
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_110.pdf", bbox_inches="tight")

