

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
import numpy as np

np.random.seed(42)
years = [2018, 2019, 2020, 2021]
utilitarianism_interest = np.array([0.2, 0.3, 0.5, 0.8])
deontology_interest = np.array([0.5, 0.4, 0.3, 0.2])

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [2017.5, 2021.5]

ylabel_value = "Interest Level"
ylim_values = [0, 1.0]
yticks_values = [0, 0.25, 0.5, 0.75, 1.0]

axvspan1_l, axvspan1_r = 2019.5, 2020.5

# Labels
label_1 = "Utilitarianism"
label_2 = "Deontology"

# Annotations
annotation_1 = "Major publication"
annotation_2 = "Shift in academia"
title_text = "Trends in Philosophical Thought"
suptitle_text = "Philosophical Interest Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(years, utilitarianism_interest, "o-", color="navy", label=label_1, linewidth=2)
ax.plot(years, deontology_interest, "s--", color="darkorange", label=label_2, linewidth=2)

# Highlight specific regions
ax.axvspan(axvspan1_l, axvspan1_r, color="lightgrey", alpha=0.5, label="Fluctuation Period")

# Annotations
ax.annotate(
    annotation_1,
    xy=(2019, 0.3),
    xytext=(2019.2, 0.5),
    arrowprops=dict(facecolor="green", shrink=0.05),
)
ax.annotate(
    annotation_2,
    xy=(2020, 0.3),
    xytext=(2020.2, 0.4),
    arrowprops=dict(facecolor="red", shrink=0.05),
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_xlim(xlim_values)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xticks(years)
ax.set_ylabel(ylabel_value)
ax.set_title(title_text)
fig.suptitle(suptitle_text)

# Add legend
ax.legend(loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_111.pdf", bbox_inches="tight")
