
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Sample data for an agriculture study on crop height (in cm) across different weeks
weeks = np.arange(1, 21)
control_group = np.linspace(30, 100, 20) + np.random.normal(0, 2, 20)  # Control group
water_treatment = np.linspace(35, 120, 20) + np.random.normal(0, 2, 20)  # Water Treatment
fertilizer_treatment = np.linspace(40, 130, 20) + np.random.normal(0, 2, 20)  # Fertilizer Treatment
combined_treatment = np.linspace(45, 140, 20) + np.random.normal(0, 2, 20)  # Combined Treatment

# Axes Limits and Labels
xlabel_value = "Week"
xlim_values = [0.5, 20.5]
xticks_values = np.arange(1, 21, 1)

ylabel_value = "Average Crop Height (cm)"
ylim_values = [20, 150]
yticks_values = np.arange(20, 151, 10)

# Labels
label_control = "Control Group"
label_water_treatment = "Water Treatment"
label_fertilizer_treatment = "Fertilizer Treatment"
label_combined_treatment = "Combined Treatment"
title="Average Crop Height Over Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))
plt.plot(
    weeks,
    control_group,
    marker="o",
    markersize=7,
    color="#1f77b4",  # Blue
    mfc="w",
    mew=1.5,
    label=label_control,
    linewidth=2,
)
plt.plot(
    weeks,
    water_treatment,
    marker="s",
    markersize=7,
    color="#ff7f0e",  # Orange
    mfc="w",
    mew=1.5,
    label=label_water_treatment,
    linewidth=2,
)
plt.plot(
    weeks,
    fertilizer_treatment,
    marker="^",
    markersize=7,
    color="#2ca02c",  # Green
    mfc="w",
    mew=1.5,
    label=label_fertilizer_treatment,
    linewidth=2,
)
plt.plot(
    weeks,
    combined_treatment,
    marker="D",
    markersize=7,
    color="#d62728",  # Red
    mfc="w",
    mew=1.5,
    label=label_combined_treatment,
    linewidth=2,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Setting x-axis ticks
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18, pad=15)

# Adding legend with a different style and position
plt.legend(frameon=True, fontsize=12, loc="upper right")

# Adding gridlines
plt.grid(True, linestyle="--", linewidth=0.6, axis="y", alpha=0.7)

# Adjusting tick label size
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_114.pdf", bbox_inches="tight")
