

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
years = [2010, 2012, 2014, 2016, 2018, 2020]
age_18_25_reading = [0.50, 0.55, 0.60, 0.65, 0.70, 0.75]
age_26_40_reading = [0.40, 0.44, 0.48, 0.52, 0.57, 0.62]
age_41_60_reading = [0.35, 0.38, 0.42, 0.46, 0.50, 0.55]

# Extracted variables
age_18_25_label = "Ages 18-25"
age_26_40_label = "Ages 26-40"
age_41_60_label = "Ages 41-60"

ylim_values = [0.30, 0.80]
yticks_values = [0.4, 0.5, 0.6, 0.7, 0.8]
yticks_labels = ["40%", "50%", "60%", "70%", "80%"]
xlabel_value = "Year"
ylabel_value = "Reading Percentage (%)"
title_value = "Public Reading Trends Over Time (2010-2020)"
xlim_values = [2009, 2021]
xticks_fontsize = "16"
yticks_fontsize = "16"
xlabel_fontsize = "14"
ylabel_fontsize = "14"
title_fontsize = "18"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

legend_location = "lower left"
legend_ncol = 3
legend_bbox_to_anchor = (0, -0.2)
legend_frameon = False

# Plot the data
ax.plot(
    years,
    age_18_25_reading,
    "o-",
    label=age_18_25_label,
    clip_on=False,
    zorder=10,
    color="#1f77b4",  # custom blue
    linewidth=1.6,
    markersize=12,
)
ax.plot(
    years,
    age_26_40_reading,
    "d-",
    label=age_26_40_label,
    clip_on=False,
    zorder=10,
    color="#ff7f0e",  # custom orange
    linewidth=1.6,
    markersize=12,
)
ax.plot(
    years,
    age_41_60_reading,
    "^-",
    label=age_41_60_label,
    clip_on=False,
    zorder=10,
    color="#2ca02c",  # custom green
    linewidth=1.6,
    markersize=12,
)

plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_labels, fontsize=yticks_fontsize)

# Set x-axis to only display specific ticks and extend x-axis to leave space at right
plt.xticks(fontsize=xticks_fontsize)
plt.xlim(xlim_values)
plt.tick_params(axis="both", which="both", color="gray")

# Add legend, labels, title, and grid
ax.legend(
    loc=legend_location,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
    frameon=legend_frameon,
)
ax.set_xlabel(xlabel_value, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel_value, fontsize=ylabel_fontsize)
ax.set_title(title_value, fontsize=title_fontsize)
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_117.pdf", bbox_inches="tight")
