# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for educational domain
exams = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9])
class_x = np.array([60, 65, 70, 75, 78, 80, 82, 85, 88])
class_x_enriched = np.array([62, 67, 72, 76, 80, 83, 86, 90, 92])
class_y = np.array([55, 60, 65, 68, 70, 73, 75, 78, 80])
class_y_enriched = np.array([57, 62, 67, 70, 73, 76, 79, 81, 83])

# Axes Limits and Labels
xlabel_value = "Exams"
ylabel_value = "Performance Score"

# Labels
label_1 = "Class X"
label_2 = "Class X (Enriched)"
label_3 = "Class Y"
label_4 = "Class Y (Enriched)"

# Titles
title_1 = "Performance in Class X over Time"
title_2 = "Performance in Class Y over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to ensure good readability
plt.figure(figsize=(12, 6))

# First subplot
plt.subplot(1, 2, 1)
plt.plot(
    exams,
    class_x,
    marker="s",
    linestyle="--",
    color="#FF6347",
    label=label_1,
    markerfacecolor="#FF6347",
    linewidth=2,
    markersize=7,
)
plt.plot(
    exams,
    class_x_enriched,
    marker="o",
    linestyle="-",
    color="#4682B4",
    label=label_2,
    markerfacecolor="#4682B4",
    linewidth=2,
    markersize=7,
)
plt.fill_between(exams, class_x - 2, class_x + 2, color="#FF6347", alpha=0.2)
plt.fill_between(
    exams, class_x_enriched - 1.5, class_x_enriched + 1.5, color="#4682B4", alpha=0.2
)
plt.title(title_1, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.legend(loc="lower right", frameon=True, fontsize=12)

# Second subplot
plt.subplot(1, 2, 2)
plt.plot(
    exams,
    class_y,
    marker="s",
    linestyle="--",
    color="#32CD32",
    label=label_3,
    markerfacecolor="#32CD32",
    linewidth=2,
    markersize=7,
)
plt.plot(
    exams,
    class_y_enriched,
    marker="o",
    linestyle="-",
    color="#8A2BE2",
    label=label_4,
    markerfacecolor="#8A2BE2",
    linewidth=2,
    markersize=7,
)
plt.fill_between(exams, class_y - 2, class_y + 2, color="#32CD32", alpha=0.2)
plt.fill_between(
    exams, class_y_enriched - 1.5, class_y_enriched + 1.5, color="#8A2BE2", alpha=0.2
)
plt.title(title_2, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.legend(loc="lower right", frameon=True, fontsize=12, bbox_to_anchor=(1, 0.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_122.pdf", bbox_inches="tight")
