

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Seed for reproducibility

# Data for plotting
years = np.array([1, 2, 10])
fossil_fuels_consumption = np.array([1000, 950, 900])
renewable_consumption = np.array([100, 300, 700])
nuclear_consumption = np.array([200, 250, 300])

# Axes Limits and Labels
xlabel_value = "Time (Years, log scale)"
xlim_values = [0.5, 20]

ylabel_value = "Average Energy Consumption (GWh)"
ylim_values = [50, 1100]
yticks_values = np.arange(100, 1101, 200)

# Labels
label_FossilFuels = "Fossil Fuels"
label_Renewable = "Renewable"
label_Nuclear = "Nuclear"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(6, 4.5))  # Adjusting figure size

# Plotting the data with new colors and styles
plt.plot(years, fossil_fuels_consumption, 'o-', color='teal', label=label_FossilFuels, linewidth=2, markersize=8)
plt.plot(years, renewable_consumption, 's--', color='orange', label=label_Renewable, linewidth=2, markersize=8)
plt.plot(years, nuclear_consumption, '^:', color='purple', label=label_Nuclear, linewidth=2, markersize=8)

# Configure y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)

# Configure x-axis fontsize and set to log scale
plt.xticks(fontsize=14)
plt.xscale("log")

# Adding labels and title with appropriate fontsize
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Adding grid with customized style
plt.grid(True, which="both", ls="-.", linewidth=0.7)

# Adding legend, adjusting its position and style
plt.legend(loc="lower right", fontsize=12, ncol=3, columnspacing=0.5, edgecolor="black")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjusting layout for better fit
plt.savefig("line_126.pdf", bbox_inches="tight")

