
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define subplot titles
titles = [
    "Regular Attendance Over Time",
    "Holiday Attendance Over Time",
    "Community Service Participation Over Time",
    "Donations Over Time",
]

# Generate new datasets for each subplot
data_sets = []
for i in range(4):
    years = np.arange(2010, 2020)
    attendance_method_1 = np.random.uniform(30, 70, len(years))
    attendance_method_2 = np.random.uniform(35, 65, len(years))
    method_3_mean = np.mean(attendance_method_1) * np.ones(len(years))
    method_4_mean = np.mean(attendance_method_2) * np.ones(len(years))
    error = np.random.uniform(2, 5, len(years))
    data_sets.append((years, attendance_method_1, attendance_method_2, method_3_mean, method_4_mean, error))

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Attendance / Participation Rate (%)"

# Labels
label_1 = "Measured Attendance"
label_2 = "Estimated Attendance"
label_3 = "Measured Mean"
label_4 = "Estimated Mean"
suptitle = "Religious Service Attendance Trends"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(18, 10))

# Color settings (use the same colors as before)
color_1 = "#1f77b4"
color_2 = "#ff7f0e"

# Loop through each subplot
for i in range(4):
    years, attendance_method_1, attendance_method_2, method_3_mean, method_4_mean, error = data_sets[i]
    
    plt.subplot(2, 2, i + 1)
    plt.plot(years, attendance_method_1, "-o", label=label_1, color=color_1, linewidth=2, markersize=8)
    plt.fill_between(
        years,
        attendance_method_1 - error,
        attendance_method_1 + error,
        color=color_1,
        alpha=0.2,
    )
    plt.plot(years, attendance_method_2, "-s", label=label_2, color=color_2, linewidth=2, markersize=8)
    plt.fill_between(
        years,
        attendance_method_2 - error,
        attendance_method_2 + error,
        color=color_2,
        alpha=0.2,
    )
    plt.plot(years, method_3_mean, "--", label=label_3, color=color_1, linewidth=2)
    plt.plot(years, method_4_mean, "--", label=label_4, color=color_2, linewidth=2)
    plt.title(titles[i], fontsize=14)
    plt.xlabel(xlabel_value, fontsize=12)
    plt.ylabel(ylabel_value, fontsize=12)
    plt.legend(loc="upper left", fontsize=10)
    plt.grid(True)

# Add supertitle
plt.suptitle(suptitle, fontsize=16)
# Adjust layout
plt.tight_layout(rect=[0, 0, 1, 0.96])

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.savefig("line_128.pdf", bbox_inches="tight")
