
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define subplot titles
titles = [
    "CityA with Regulations",
    "CityA without Regulations",
    "CityB with Regulations",
    "CityB without Regulations",
]

# Generate sample air quality data
months = np.linspace(0, 5, 5)
cityA_with_reg = np.linspace(50, 40, len(months)) + np.random.uniform(-5, 5, len(months))
cityA_without_reg = np.linspace(60, 70, len(months)) + np.random.uniform(-5, 5, len(months))
cityB_with_reg = np.linspace(55, 45, len(months)) + np.random.uniform(-5, 5, len(months))
cityB_without_reg = np.linspace(65, 75, len(months)) + np.random.uniform(-5, 5, len(months))

# Error for sample data
error_A = np.random.uniform(2, 4, len(months))
error_B = np.random.uniform(2, 4, len(months))

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Air Quality Index (AQI)"

# Labels
label_1 = "CityA with Regulations"
label_2 = "CityA without Regulations"
label_3 = "CityB with Regulations"
label_4 = "CityB without Regulations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(16, 8))

# Custom colors
color_A = "#2ca02c"  # Calming green
color_B = "#1f77b4"  # Calming blue

# Loop through each subplot
for i in range(4):
    plt.subplot(2, 2, i + 1)
    
    if i == 0:
        plt.plot(months, cityA_with_reg, "-o", label=label_1, color=color_A)
        plt.fill_between(
            months,
            cityA_with_reg - error_A,
            cityA_with_reg + error_A,
            color=color_A,
            alpha=0.2,
        )
    elif i == 1:
        plt.plot(months, cityA_without_reg, "-o", label=label_2, color=color_A)
        plt.fill_between(
            months,
            cityA_without_reg - error_A,
            cityA_without_reg + error_A,
            color=color_A,
            alpha=0.2,
        )
    elif i == 2:
        plt.plot(months, cityB_with_reg, "--s", label=label_3, color=color_B)
        plt.fill_between(
            months,
            cityB_with_reg - error_B,
            cityB_with_reg + error_B,
            color=color_B,
            alpha=0.2,
        )
    elif i == 3:
        plt.plot(months, cityB_without_reg, "--s", label=label_4, color=color_B)
        plt.fill_between(
            months,
            cityB_without_reg - error_B,
            cityB_without_reg + error_B,
            color=color_B,
            alpha=0.2,
        )

    plt.title(titles[i])
    plt.xlabel(xlabel_value)
    plt.ylabel(ylabel_value)
    plt.legend(loc="upper left")
    plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Show the plot
plt.savefig("line_129.pdf", bbox_inches="tight")
