
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Importing numpy for data creation
import numpy as np

# Generating new data
years = ["2011", "2012", "2013", "2014", "2015", "2016", "2017", "2018", "2019", "2020"]
traffic_volume = [45, 47, 50, 52, 55, 57, 60, 63, 65, 48]  # in thousands (vehicles per day)
average_speed = [60, 62, 61, 63, 64, 65, 66, 67, 68, 55]  # in km/h

# Variables for plot configuration
traffic_label = "Traffic Volume (thousands)"
speed_label = "Average Speed (km/h)"
xlim_values = (0, len(years) - 1)
ylim_values = (40, 70)  # Adjusted based on new data
xlabel_text = "Year"
ylabel_text = "Value"
xticks_values = np.arange(len(years))
yticks_values = [40, 45, 50, 55, 60, 65, 70]
xtickslabel_fontsize = 14
ytickslabel_fontsize = 14
title_text = "Traffic Volume and Average Speed Over Time"
axhline_value = None
axvline_value = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(10, 6))  # Adjusting figure size
plt.plot(
    years,
    traffic_volume,
    marker="^",
    linestyle="-",
    linewidth=3,
    clip_on=False,
    zorder=10,
    color="#FF6347",  # Tomato color for Traffic Volume
    markersize=10,
    label=traffic_label,
    mec="#FF4500",  # OrangeRed color for edge
    mfc="white",
    mew=2,
)
plt.plot(
    years,
    average_speed,
    marker="d",
    linestyle="--",
    linewidth=3,
    clip_on=False,
    zorder=10,
    color="#4682B4",  # SteelBlue color for Average Speed
    markersize=10,
    label=speed_label,
    mec="#4169E1",  # RoyalBlue color for edge
    mfc="white",
    mew=2,
)

# Adding titles and labels with adjusted font size
plt.yticks(yticks_values, fontsize=ytickslabel_fontsize)
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)
plt.ylim(*ylim_values)
plt.xlim(*xlim_values)
plt.xlabel(xlabel_text, fontsize=xtickslabel_fontsize)
plt.ylabel(ylabel_text, fontsize=ytickslabel_fontsize)
plt.title(title_text, fontsize=16, pad=20)

# Adding legend with enhanced style
plt.legend(
    markerscale=1,
    fontsize=14,
    loc="upper center",
    bbox_to_anchor=(0.5, -0.1),
    ncol=2,
    frameon=False,
)

# Changing the background color to a soft gray
plt.gca().set_facecolor("#eaeaf2")

# Adjusting the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#eaeaf2")
ax.spines["top"].set_color("#eaeaf2")  # Optional: hide or set color
ax.spines["left"].set_color("#eaeaf2")
ax.spines["right"].set_color("#eaeaf2")  # Optional: hide or set color

plt.tick_params(axis="both", which="both", length=0)
# Adding grid
plt.grid(True, color="white")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the bottom for the legend
plt.tight_layout()
plt.savefig("line_133.pdf", bbox_inches="tight")
