
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data representing years from 2000 to 2020
x = [2000, 2002, 2004, 2006, 2008, 2010, 2012, 2014, 2016, 2018, 2020]
y = [280.4, 275.6, 273.1, 270.8, 265.7, 260.5, 255.3, 248.9, 242.5, 238.7, 230.1]
labels = [
    "280.4", "275.6", "273.1", "270.8", "265.7", "260.5", "255.3", "248.9", "242.5", "238.7", "230.1"
]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1998, 2022]
xticks_values = [2000, 2004, 2008, 2012, 2016, 2020]
xticklabels = [str(year) for year in xticks_values]

ylabel_value = "Avg. TV Viewership (millions)"
ylim_values = [225, 285]
yticks_values = np.arange(230, 281, 10)

# Text Labels and Title
title_value = "Annual Average TV Viewership Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(6, 3))  # Adjust the size to match the new arrangement
ax.plot(
    x,
    y,
    marker="^",
    color="#2ca02c",
    linestyle="--",
    linewidth=2,
    markersize=6,
    mfc="red",
    mec="white",
)

# Annotate each point with its label
for i, label in enumerate(labels):
    ax.annotate(
        label,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=7,
    )

# Configure x-axis
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)
ax.set_xlim(xlim_values)

# Configure y-axis
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)

# Set labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value, fontsize=12, weight='bold', color="#2ca02c")

# Change the plot background color
ax.set_facecolor("#f4f6f8")

# Show grid
plt.grid(True, which="both", linestyle="--", linewidth=0.5, color="#e5e5e5")

# Change the axis colors
ax.spines["bottom"].set_color("#d3d3d3")
ax.spines["top"].set_color("#d3d3d3")
ax.spines["left"].set_color("#d3d3d3")
ax.spines["right"].set_color("#d3d3d3")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_138.pdf", bbox_inches="tight")
