
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data: Transportation trends
weeks = np.arange(1, 11, 1)
average_traffic_volume = np.array([1000, 1100, 1200, 1300, 1400, 1350, 1250, 1150, 1050, 950])
average_public_transport = np.array([200, 210, 220, 230, 240, 250, 260, 270, 280, 290])
std_dev_traffic_volume = np.array([100, 100, 100, 100, 100, 100, 100, 100, 100, 100])
std_dev_public_transport = np.array([20, 20, 20, 20, 20, 20, 20, 20, 20, 20])

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Number of Vehicles/Riders"
ylim_values = [0, 1600]
yticks_values = np.arange(0, 1601, 400)

# Labels
label_traffic_volume = "Average Traffic Volume"
label_public_transport = "Public Transport Usage"
title = "Weekly Transportation Trends"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 5))

# Plotting Traffic Volume
plt.plot(weeks, average_traffic_volume, label=label_traffic_volume, marker="s", linestyle="--", color="#ff7f0e", linewidth=2, markersize=6)
plt.fill_between(
    weeks,
    average_traffic_volume - std_dev_traffic_volume,
    average_traffic_volume + std_dev_traffic_volume,
    color="#ff7f0e",
    alpha=0.2,
)

# Plotting Public Transport Usage
plt.plot(weeks, average_public_transport, label=label_public_transport, marker="^", linestyle="-", color="#2ca02c", linewidth=2, markersize=6)
plt.fill_between(
    weeks,
    average_public_transport - std_dev_public_transport,
    average_public_transport + std_dev_public_transport,
    color="#2ca02c",
    alpha=0.2,
)

# Adjusting y-axis range and ticks
plt.ylim(ylim_values)
plt.yticks(yticks_values)

# Adding labels and title with enhanced font size
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=14)

# Adding legend
plt.legend(frameon=True, fontsize=12)

# Adding grid
plt.grid(True, color="#d1d1d1", linestyle=":")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_141.pdf", bbox_inches="tight")
