

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Dummy data for the purpose of plotting. In a real scenario, you would use your actual data.
seasons = np.array(["Spring", "Summer", "Fall", "Winter"])

# Average Temperatures (°C) for Location A
location1_temp = np.array([15, 25, 10, 0]) + np.random.normal(0, 1, 4)
location2_temp = np.array([18, 28, 13, 3]) + np.random.normal(0, 1, 4)
location3_temp = np.array([20, 30, 15, 5]) + np.random.normal(0, 1, 4)

# Error for Temperatures
error_temp = np.array([2, 2, 2, 2])

# Average Precipitation (mm) for Location B
location1_precip = np.array([60, 80, 40, 30]) + np.random.normal(0, 5, 4)
location2_precip = np.array([55, 75, 35, 25]) + np.random.normal(0, 5, 4)
location3_precip = np.array([50, 70, 30, 20]) + np.random.normal(0, 5, 4)

# Error for Precipitation
error_precip = np.array([5, 5, 5, 5])

# Axes Limits and Labels
ylabel_temp = "Average Temperature (°C)"
ylabel_precip = "Average Precipitation (mm)"
ylim_temp = [-5, 35]
yticks_temp = [-5, 0, 5, 10, 15, 20, 25, 30, 35]
ylim_precip = [0, 100]
yticks_precip = [0, 20, 40, 60, 80, 100]

# Labels
label_Location1 = "Location 1"
label_Location2 = "Location 2"
label_Location3 = "Location 3"

# Texts
xlabel = "Seasons"
ylabel_combined = "Average Environmental Measures"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create two subplots and unpack the output array immediately
f, (ax1, ax2) = plt.subplots(2, 1, sharex=True, figsize=(8, 6))

# First subplot for Temperature
ax1.errorbar(
    seasons,
    location1_temp,
    yerr=error_temp,
    label=label_Location1,
    color="#1f77b4",
    marker="o",
    linestyle='-', 
    linewidth=2
)
ax1.errorbar(
    seasons,
    location2_temp,
    yerr=error_temp,
    label=label_Location2,
    color="#ff7f0e",
    marker="s",
    linestyle='--', 
    linewidth=2
)
ax1.errorbar(
    seasons,
    location3_temp,
    yerr=error_temp,
    label=label_Location3,
    color="#2ca02c",
    marker="^",
    linestyle=':', 
    linewidth=2
)
ax1.set_ylabel(ylabel_temp)
# Set grid
ax1.grid(True)
ax1.set_ylim(ylim_temp)
ax1.set_yticks(yticks_temp)

# Second subplot for Precipitation
ax2.errorbar(
    seasons,
    location1_precip,
    yerr=error_precip,
    label=label_Location1,
    color="#1f77b4",
    marker="o",
    linestyle='-', 
    linewidth=2
)
ax2.errorbar(
    seasons,
    location2_precip,
    yerr=error_precip,
    label=label_Location2,
    color="#ff7f0e",
    marker="s",
    linestyle='--', 
    linewidth=2
)
ax2.errorbar(
    seasons,
    location3_precip,
    yerr=error_precip,
    label=label_Location3,
    color="#2ca02c",
    marker="^",
    linestyle=':', 
    linewidth=2
)
ax2.set_ylabel(ylabel_precip)
# Set grid
ax2.grid(True)
ax2.set_ylim(ylim_precip)
ax2.set_yticks(yticks_precip)

# Only show ticks on the bottom subplot
plt.setp(ax1.get_xticklabels(), visible=False)

# Create legend above the second subplot
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Set the figure's layout so there is space for the xlabel at the bottom
plt.tight_layout()

# Now adjust the subplot to give space for the ylabel on the left
f.subplots_adjust(left=0.15, bottom=0.12)

# Place the legend and adjust subplot parameters
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

f.text(0.55, 0.05, xlabel, ha="center", va="center")
f.text(
    0.05,
    0.5,
    ylabel_combined,
    ha="center",
    va="center",
    rotation="vertical",
)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_144.pdf", bbox_inches="tight")

