

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting - Energy consumption rates over years
years = ["2010", "2012", "2014", "2016", "2018", "2020", "2022"]
consumption_coal = [0.8, 0.75, 0.7, 0.65, 0.55, 0.45, 0.35]
consumption_natural_gas = [0.4, 0.45, 0.55, 0.6, 0.65, 0.68, 0.7]
consumption_renewable = [0.1, 0.15, 0.2, 0.3, 0.45, 0.55, 0.7]

# Variables for plot configuration
line_labels = ["Coal Consumption", "Natural Gas Consumption", "Renewable Energy Consumption"]
xlim_values = (0, len(years) - 1)
ylim_values = (0.0, 1.0)
xlabel_value = "Year"
ylabel_value = "Consumption Rate"
xticks_values = range(len(years))
yticks_values = np.arange(0.0, 1.1, 0.2)
xtickslabel_values = years
ytickslabel_values = None
title_value = "Energy Consumption Rates Over Time"
axhline_value = None
axvline_value = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(10, 7))
plt.plot(
    years,
    consumption_coal,
    "o-",
    clip_on=False,
    zorder=10,
    color="#1f77b4",  # Blue
    label=line_labels[0],
    linestyle="dotted",
    linewidth=2,
    marker="o",
    markersize=8
)
plt.plot(
    years,
    consumption_natural_gas,
    "s-",
    clip_on=False,
    zorder=10,
    color="#2ca02c",  # Green
    label=line_labels[1],
    linestyle="dashed",
    linewidth=2,
    marker="s",
    markersize=8
)
plt.plot(
    years,
    consumption_renewable,
    "^-",
    clip_on=False,
    zorder=10,
    color="#9467bd",  # Purple
    label=line_labels[2],
    linestyle="solid",
    linewidth=2,
    marker="^",
    markersize=8
)

# Setting x and y ticks
plt.xticks(xticks_values, xtickslabel_values, fontsize=14)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=14)

# Adding minor y-axis ticks with a step of 0.05
ax = plt.gca()
ax.yaxis.set_minor_locator(MultipleLocator(0.05))

# Adjust tick parameters
ax.tick_params(axis="both", which="both", length=5, color="gray")  # Move ticks inside
ax.tick_params(
    axis="y", which="minor", length=2
)  # Ensure minor ticks are visible but smaller

# Title and labels
plt.title(title_value, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# Enable gridlines for minor ticks
plt.grid(True, color="#b0b0b0", which="major", linestyle="-", linewidth=0.5)
plt.grid(True, color="#d0d0d0", which="minor", linestyle="--", linewidth=0.5)

# Legend with serif font family
plt.legend(
    frameon=False, fontsize=12, loc="upper left"
)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()

plt.savefig("line_146.pdf", bbox_inches="tight")

