

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021"]
religion_a = [1.2, 1.25, 1.35, 1.4, 1.45, 1.5, 1.55]
religion_b = [0.8, 0.85, 0.9, 0.95, 1.0, 1.05, 1.1]
religion_c = [0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8]

# Variables for plot configuration
line_labels = ["Religion A", "Religion B", "Religion C"]
xlim_values = (0, len(years) - 1)
ylim_values = (0.4, 1.6)
xlabel_value = "Years"
ylabel_value = "Number of Followers (in millions)"
xticks_values = range(len(years))
yticks_values = np.arange(0.4, 1.7, 0.2)
xtickslabel_values = years
ytickslabel_values = None
title_value = "Growth in Number of Followers Over Years"
axhline_value = None
axvline_value = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

plt.figure(figsize=(10, 7))
plt.plot(
    years,
    religion_a,
    "s--",
    clip_on=False,
    zorder=10,
    color="#1f77b4",  # Dark blue
    label=line_labels[0],
    linewidth=2,
)
plt.plot(
    years,
    religion_b,
    "^--",
    clip_on=False,
    zorder=10,
    color="#2ca02c",  # Dark green
    label=line_labels[1],
    linewidth=2,
)
plt.plot(
    years,
    religion_c,
    "o--",
    clip_on=False,
    zorder=10,
    color="#d62728",  # Dark red
    label=line_labels[2],
    linewidth=2,
)

# Setting x and y ticks
plt.xticks(xticks_values, xtickslabel_values, fontsize=14)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=14)

# Adding minor y-axis ticks with a step of 0.05
ax = plt.gca()
ax.yaxis.set_minor_locator(MultipleLocator(0.05))

# Adjust tick parameters
ax.tick_params(axis="both", which="both", length=5, color="gray")  # Move ticks inside
ax.tick_params(
    axis="y", which="minor", length=3  # Adjusting minor tick length for better visibility
)

# Title and labels
plt.title(title_value, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# Enable gridlines for major and minor ticks
plt.grid(True, color="#b0b0b0", which="both", linestyle="-", linewidth=0.5)

# Legend with serif font family
plt.legend(
    frameon=False, fontsize=12, loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3
)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()

plt.savefig("line_148.pdf", bbox_inches="tight")
