

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
years = [2010, 2012, 2014, 2016, 2018, 2020]
author_a_sales = [35.0, 50.0, 70.0, 85.0, 95.0, 110.0]
author_b_sales = [45.0, 60.0, 80.0, 90.0, 100.0, 120.0]
author_c_sales = [30.0, 40.0, 60.0, 70.0, 85.0, 100.0]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [2008, 2022]
xticks_values = [2010, 2012, 2014, 2016, 2018, 2020]
xticklabels = ["2010", "2012", "2014", "2016", "2018", "2020"]

ylabel_value = "Book Sales (Thousands)"
ylim_values = [0, 130]
yticks_values = np.arange(0, 131, 20)

# Labels
label_author_A = "Author A"
label_author_B = "Author B"
label_author_C = "Author C"

title = 'Book Sales Over a Decade'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years, author_a_sales, "o-", label=label_author_A, color="#2C7BB6", linestyle='-', linewidth=2, markersize=6
)
plt.plot(
    years, author_b_sales, "s-", label=label_author_B, color="#ABD9E9", linestyle='--', linewidth=2, markersize=6
)
plt.plot(
    years, author_c_sales, "^-", label=label_author_C, color="#FDAE61", linestyle='-.', linewidth=2, markersize=6
)

# Set x-axis and y-axis ticks and limits
plt.xticks(xticks_values, xticklabels)
plt.xlim(xlim_values)
plt.ylim(ylim_values)
plt.yticks(yticks_values)

# Adding data labels
for i, txt in enumerate(author_a_sales):
    plt.annotate(
        txt,
        (years[i], author_a_sales[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(author_b_sales):
    plt.annotate(
        txt,
        (years[i], author_b_sales[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(author_c_sales):
    plt.annotate(
        txt,
        (years[i], author_c_sales[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )

# Setting the axis labels and title
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title, fontsize=16)

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#cccccc")
ax.spines["bottom"].set_linewidth(1.4)
ax.spines["left"].set_color("#cccccc")
ax.spines["left"].set_linewidth(1.4)
ax.spines["top"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# Adjust tick parameters to ensure ticks do not extend outside
ax.tick_params(axis="both", which="both", length=0)  # Hide tick marks

# Adding the legend
plt.legend(loc="lower right")

# Adding grid
plt.grid(True, which="both", linestyle="--", linewidth=1, color="#808080")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_149.pdf", bbox_inches="tight")

