

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
years = [2000, 2005, 2010, 2015, 2020]
city_x_temperature = [15, 16, 16.5, 17, 17.5]
city_y_temperature = [20, 21, 21.5, 22, 22.5]
city_z_temperature = [10, 10.5, 11, 11.5, 12]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1998, 2022]
xticks_values = years
xticklabels = [str(year) for year in years]

ylabel_value = "Temperature (in °C)"
ylim_values = [9, 23]

# Labels
label_cityX = "City X"
label_cityY = "City Y"
label_cityZ = "City Z"

# Title
title_value = "Temperature Trends Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))
plt.plot(
    years, city_x_temperature, "o-", label=label_cityX, color="#1f77b4", markersize=6, linewidth=2
)
plt.plot(
    years, city_y_temperature, "x--", label=label_cityY, color="#ff7f0e", markersize=6, linewidth=2
)
plt.plot(
    years, city_z_temperature, "s-.", label=label_cityZ, color="#2ca02c", markersize=6, linewidth=2
)

# Set x-axis and y-axis limits and ticks
plt.xticks(xticks_values, xticklabels, fontsize=12)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Adding data labels
for i, txt in enumerate(city_x_temperature):
    plt.annotate(
        txt,
        (years[i], city_x_temperature[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(city_y_temperature):
    plt.annotate(
        txt,
        (years[i], city_y_temperature[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(city_z_temperature):
    plt.annotate(
        txt,
        (years[i], city_z_temperature[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )

# Setting the axis labels and title
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16, fontweight='bold')

# Customize the axis colors and line widths
ax = plt.gca()
ax.spines["bottom"].set_color("#7f7f7f")
ax.spines["bottom"].set_linewidth(1.4)
ax.spines["left"].set_color("#7f7f7f")
ax.spines["left"].set_linewidth(1.4)
ax.spines["top"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# Adjust tick parameters to ensure ticks do not extend outside
ax.tick_params(axis="both", which="major", length=6, width=1.2, colors="#7f7f7f")
ax.tick_params(axis="both", which="minor", length=4, width=1, colors="#7f7f7f")

# Adding the legend
plt.legend(loc="upper left", fontsize=12)

# Adding grid
plt.grid(True, which="both", linestyle="--", linewidth=0.5, color="#b0b0b0")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_150.pdf", bbox_inches="tight")

