
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
x = [2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010]
population_y = [200, 210, 220, 230, 250, 275, 300, 330, 360, 390, 400]
urbanization_rate_y = [50, 55, 60, 65, 70, 75, 77, 78, 79, 80, 81]
baseline_population = 100

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1999, 2011]
xticks_values = np.arange(2000, 2011, 1)

ylabel_value = "Population / Urbanization Rate (%)"
ylim_values = [0, 450]
yticks_values = np.arange(0, 450, 50)

# Labels
label_1 = "Population (in millions)"
label_2 = "Urbanization Rate (%)"
label_3 = "Baseline Population (100 million)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 5))

# Line charts
line_color_1 = "#8B4513"
line_color_2 = "#A52A2A"
baseline_color = "#556B2F"

ax.plot(x, population_y, marker="o", color=line_color_1, label=label_1, linestyle='-', linewidth=2)
ax.plot(x, urbanization_rate_y, marker="^", color=line_color_2, label=label_2, linestyle='--', linewidth=2)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=12)
plt.xticks(xticks_values, fontsize=12)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Horizontal dashed line
ax.axhline(y=baseline_population, color=baseline_color, linestyle="-.", label=label_3, linewidth=2)

# Grid
ax.grid(True, linestyle='--', linewidth=0.5, color='gray', alpha=0.7)

# Legend
ax.legend(loc="upper left")

# Labels
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_154.pdf", bbox_inches="tight")
