

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generate new data for a religion domain
years = range(1, 21)
movement_a_followers = np.cumsum(np.random.normal(100, 20, 20))
movement_b_followers = np.cumsum(np.random.normal(150, 50, 20))

# Axes Limits and Labels
xlabel_value = "Years"
xlim_values = [0, 21]
xticks_values = [0, 5, 10, 15, 20]

ylabel_value = "Number of Followers (in thousands)"
ylim_values = [movement_a_followers.min()-50, movement_b_followers.max()+50]

# Labels
label_1 = "Movement A"
label_2 = "Movement B"
title = "Growth of Religious Movements Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(6, 4))
plt.plot(years, movement_a_followers, "o-", label=label_1, color="#1f77b4")
plt.plot(years, movement_b_followers, "s--", label=label_2, color="#ff7f0e")

# Adding legend
plt.legend()

# Labeling axes
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xlim(xlim_values)
plt.xticks(xticks_values)
plt.grid(True, linestyle='--', linewidth=0.5, color='gray')

# Adding plot title
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_157.pdf", bbox_inches="tight")

