# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
years = np.arange(2010, 2021)
school_a_graduation_rates = [
    82,
    85,
    88,
    90,
    92,
    93,
    95,
    96,
    97,
    98,
    99,
]
school_b_graduation_rates = [
    75,
    78,
    80,
    83,
    85,
    87,
    88,
    89,
    90,
    92,
    94,
]

# Extracted variables
school_a_label = "School A"
school_b_label = "School B"
xlim_values = [2010, 2020]
ylim_values = [70, 100]
xlabel_value = "Year"
ylabel_value = "Graduation Rate (%)"
xticks_values = years
yticks_values = np.arange(70, 101, 5)
xtickslabel_values = []
ytickslabel_values = [str(i) for i in yticks_values]
title_value = "Graduation Rates Over a Decade"
legend_location = "upper left"
legend_bbox_to_anchor = (0.1, 1.0)
legend_ncol = 1
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(8, 6)
)  # Adjusted to match the original image's dimensions

# Plot lines
ax.plot(
    years,
    school_a_graduation_rates,
    marker="s",
    linestyle="--",
    linewidth=2,
    clip_on=False,
    zorder=10,
    color="green",
    label=school_a_label,
    markersize=8,
    mec="darkgreen",
)
ax.plot(
    years,
    school_b_graduation_rates,
    marker="o",
    linestyle="-.",
    linewidth=2,
    clip_on=False,
    zorder=10,
    color="blue",
    label=school_b_label,
    markersize=8,
    mec="darkblue",
)

# Set x, y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xlim(xlim_values)

# Title and labels
ax.set_title(title_value, fontsize=16)
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.tick_params(axis="both", which="both", length=0)

# Add gridlines
ax.grid(True, linestyle="--", alpha=0.7)

# Legend
ax.legend(
    loc=legend_location,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
    fontsize=12,
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("line_159.pdf", bbox_inches="tight")
