
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
years = [2000, 2004, 2008, 2012, 2016, 2020]
gdp_growth_country_a = [
    3.0,
    2.5,
    2.8,
    3.2,
    2.9,
    3.1,
]
gdp_growth_country_b = [
    2.1,
    2.4,
    2.2,
    2.7,
    2.5,
    2.8,
]

# Extracted variables
country_a_label = "GDP Growth Rate (Country A)"
country_b_label = "GDP Growth Rate (Country B)"
xlim_values = [2000, 2020]
ylim_values = [1.5, 3.5]
xlabel_value = "Year"
ylabel_value = "GDP Growth Rate (%)"
xticks_values = years
yticks_values = np.arange(1.5, 3.6, 0.5)
xtickslabel_values = [str(year) for year in years]
ytickslabel_values = [f'{i}%' for i in yticks_values]
title_value = "GDP Growth Rates Over Years"
legend_location = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_ncol = 2
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(8, 6)
)  # Adjusted size for better readability

# Plot lines
ax.plot(
    years,
    gdp_growth_country_a,
    marker="o",
    linestyle='-',
    clip_on=False,
    zorder=10,
    color="#377eb8",  # Blue color
    label=country_a_label,
    markersize=8,
    mec="white",
)
ax.plot(
    years,
    gdp_growth_country_b,
    marker="s",
    linestyle='--',
    clip_on=False,
    zorder=10,
    color="#e41a1c",  # Red color
    label=country_b_label,
    markersize=8,
    mec="white",
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, ytickslabel_values, fontsize=10)
plt.xticks(xticks_values, xtickslabel_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xlim(xlim_values)

# Title and labels
ax.set_title(title_value, fontsize=14)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.tick_params(axis="both", which="both", length=0)

# Legend
ax.legend(
    loc=legend_location,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("line_160.pdf", bbox_inches="tight")
