
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New data for agricultural yield analysis
seasons = np.array(["Spring", "Summer", "Fall", "Winter"])
wheat_yield = [2.5, 3.0, 2.8, 2.6]
corn_yield = [3.0, 3.5, 3.2, 3.0]
soybean_yield = [2.8, 3.2, 3.0, 2.7]
rice_yield = [3.2, 3.6, 3.5, 3.1]

# Placeholder error values
wheat_error = np.random.uniform(0.1, 0.3, len(seasons))
corn_error = np.random.uniform(0.1, 0.3, len(seasons))
soybean_error = np.random.uniform(0.1, 0.3, len(seasons))
rice_error = np.random.uniform(0.1, 0.3, len(seasons))

# Axes Limits and Labels
xlabel_value = "Season"
ylabel_value = "Crop Yield (tons per hectare)"
ylim_values = [2.0, 4.0]
yticks_values = np.arange(2.0, 4.1, 0.5)

# Labels
label_1 = "Wheat Yield"
label_2 = "Corn Yield"
label_3 = "Soybean Yield"
label_4 = "Rice Yield"
title="Seasonal Crop Yields in Tons per Hectare for Various Crops"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))

color_1 = "#4B8BBE"
color_2 = "#306998"
color_3 = "#FFD43B"
color_4 = "#646464"

plt.errorbar(
    seasons,
    wheat_yield,
    yerr=wheat_error,
    fmt="-o",
    label=label_1,
    color=color_1,
    linestyle="--",
    linewidth=1.5,
    markersize=8,
)
plt.errorbar(
    seasons,
    corn_yield,
    yerr=corn_error,
    fmt="-s",
    label=label_2,
    color=color_2,
    linestyle="--",
    linewidth=1.5,
    markersize=8,
)
plt.errorbar(
    seasons,
    soybean_yield,
    yerr=soybean_error,
    fmt="-^",
    label=label_3,
    color=color_3,
    linestyle="--",
    linewidth=1.5,
    markersize=8,
)
plt.errorbar(
    seasons,
    rice_yield,
    yerr=rice_error,
    fmt="-d",
    label=label_4,
    color=color_4,
    linestyle="--",
    linewidth=1.5,
    markersize=8,
)

# Adding labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(seasons)
plt.ylim(ylim_values)
plt.yticks(yticks_values)
plt.title(title)

# Adding legend, lower right corner
plt.legend(loc="lower right")

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["right"].set_color("none")
ax.spines["top"].set_color("none")
ax.grid(True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_161.pdf", bbox_inches="tight")
