

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# New Data: Percentages of Different Legal Cases Won by Plaintiffs Over Several Years
years = np.array([2015, 2016, 2017, 2018, 2019, 2020, 2021])
civil_rights_cases = [0.58, 0.6, 0.62, 0.64, 0.65, 0.66, 0.68]
employment_law_cases = [0.52, 0.53, 0.55, 0.57, 0.58, 0.6, 0.63]
contract_disputes = [0.4, 0.42, 0.44, 0.45, 0.46, 0.48, 0.5]
personal_injury_cases = [0.7, 0.72, 0.74, 0.75, 0.76, 0.78, 0.8]

# Error values
civil_rights_error = np.random.uniform(0.01, 0.02, len(years))
employment_law_error = np.random.uniform(0.01, 0.02, len(years))
contract_disputes_error = np.random.uniform(0.01, 0.02, len(years))
personal_injury_error = np.random.uniform(0.01, 0.02, len(years))

# Axes Limits and Labels
xlabel_value = "Years"

ylabel_value = "Percentage of Cases Won by Plaintiffs"
ylim_values = [0.35, 0.85]
yticks_values = np.arange(0.35, 0.9, 0.05)

# Labels
label_civil = "Civil Rights"
label_employment = "Employment Law"
label_contract = "Contract Disputes"
label_personal = "Personal Injury"

title="Percentage of Legal Cases Won by Plaintiffs Over the Years"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size for better clarity
plt.errorbar(
    years,
    civil_rights_cases,
    yerr=civil_rights_error,
    fmt="-o",
    label=label_civil,
    color="#1f77b4",  # Blue
    linestyle="dashdot",
    linewidth=2,
    markersize=8
)
plt.errorbar(
    years,
    employment_law_cases,
    yerr=employment_law_error,
    fmt="-s",
    label=label_employment,
    color="#ff7f0e",  # Orange
    linestyle="dotted",
    linewidth=2,
    markersize=8
)
plt.errorbar(
    years,
    contract_disputes,
    yerr=contract_disputes_error,
    fmt="-^",
    label=label_contract,
    color="#2ca02c",  # Green
    linestyle="dashed",
    linewidth=2,
    markersize=8
)
plt.errorbar(
    years,
    personal_injury_cases,
    yerr=personal_injury_error,
    fmt="-d",
    label=label_personal,
    color="#d62728",  # Red
    linestyle="solid",
    linewidth=2,
    markersize=8
)

# Adding labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(years)
plt.ylim(ylim_values)
plt.yticks(yticks_values)
plt.title(title)

# Adding legend, lower right corner
plt.legend(loc="lower right")

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(
    True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5
)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_162.pdf", bbox_inches="tight")

