
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(164)
# Data for plotting
months = np.arange(1, 13)
passengers = np.random.randint(20000, 50000, size=12)
on_time_rate = np.random.uniform(0.7, 0.95, size=12)

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [0, 13]
xticks_values = np.arange(1, 13, 1)

ylabel_passengers = "Number of Passengers"
ylim_passengers = [0, 60000]
yticks_passengers = np.arange(0, 60001, 10000)

ylabel_on_time = "On-Time Arrival Rate (%)"
ylim_on_time = [0, 100]
yticks_on_time = np.arange(0, 101, 20)

# Labels
label_passengers = "Number of Passengers"
label_on_time = "On-Time Arrival Rate"

# Titles
title = "Monthly Transportation Trends"
legend_title = "Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the line that we will manipulate
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot passengers data
color_passengers = "#1f77b4"  # Blue color
ax1.plot(
    months,
    passengers,
    marker="o",
    color=color_passengers,
    linewidth=2,
    markersize=6,
    markerfacecolor=color_passengers,
    label=label_passengers,
)

ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_passengers, fontsize=14, color=color_passengers)
ax1.set_xticks(xticks_values)
ax1.set_xlim(xlim_values)
ax1.set_yticks(yticks_passengers)
ax1.set_ylim(ylim_passengers)
ax1.tick_params(axis="y", labelcolor=color_passengers)

# Create a twin y-axis to plot on-time arrival rate
ax2 = ax1.twinx()
color_on_time = "#2ca02c"  # Green color
ax2.plot(
    months,
    on_time_rate * 100,
    linestyle="--",
    marker="x",
    color=color_on_time,
    linewidth=2,
    markersize=6,
    markerfacecolor=color_on_time,
    label=label_on_time,
)

ax2.set_ylabel(ylabel_on_time, fontsize=14, color=color_on_time)
ax2.set_yticks(yticks_on_time)
ax2.set_ylim(ylim_on_time)
ax2.tick_params(axis="y", labelcolor=color_on_time)

# Set the title
ax1.set_title(title, fontsize=20)

# Add a legend with a title
fig.legend(
    loc="lower left",
    fontsize=12,
    title=legend_title,
    title_fontsize=12,
    bbox_to_anchor=(0.1, 0.15),
)

# Change the plot background color
ax1.set_facecolor("#f5f5f5")
ax2.set_facecolor("#f5f5f5")

# Show grid with lighter color
ax1.grid(True, color="#e1e1e1", linewidth=1.5)

# Change the axis colors
ax1.spines["bottom"].set_color("#ffffff")
ax1.spines["top"].set_color("#ffffff")
ax1.spines["left"].set_color("#ffffff")
ax1.spines["right"].set_color("#ffffff")
ax2.spines["bottom"].set_color("#ffffff")
ax2.spines["top"].set_color("#ffffff")
ax2.spines["left"].set_color("#ffffff")
ax2.spines["right"].set_color("#ffffff")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_164.pdf", bbox_inches="tight")
