

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Setting seed for reproducibility

# Data for plotting
campaigns = ["Campaign A", "Campaign B", "Campaign C", "Campaign D"]
avg_view_duration_youtube = [5.2, 6.8, 5.5, 7.0]  # average duration in minutes
avg_view_duration_tiktok = [4.0, 4.5, 4.8, 5.1]  # average duration in minutes

# Axes Limits and Labels
xlabel_value = "Marketing Campaigns"
xlim_values = [-0.5, 3.5]
xticks_values = range(len(campaigns))
xticks_labels = campaigns

ylabel_value = "Average View Duration (minutes)"
ylim_values = [3.5, 7.5]
yticks_values = np.arange(3.5, 8.0, 0.5)

# Labels
label_youtube = "YouTube"
label_tiktok = "TikTok"

# Titles
title_1 = "Average View Duration by Campaign"
title_2 = "Platforms"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the line that we will manipulate
fig, ax = plt.subplots(figsize=(10, 6))

# Plot YouTube Average View Duration
ax.plot(
    campaigns,
    avg_view_duration_youtube,
    marker="o",
    color="#1f77b4",  # Blue color for YouTube
    linewidth=2,
    markersize=8,
    markerfacecolor="#1f77b4",
    label=label_youtube,
)

# Plot TikTok Average View Duration
ax.plot(
    campaigns,
    avg_view_duration_tiktok,
    marker="s",
    color="#ff7f0e",  # Orange color for TikTok
    linewidth=2,
    markersize=8,
    markerfacecolor="#ff7f0e",
    linestyle='--',
    label=label_tiktok,
)

# Set the x and y ticks and labels
plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)
plt.xticks(xticks_values, xticks_labels, fontsize=12)
plt.xlim(xlim_values)

# Set the title and labels
ax.set_title(title_1, fontsize=20, fontweight='bold')
ax.set_xlabel(xlabel_value, fontsize=16)
ax.set_ylabel(ylabel_value, fontsize=16)

# Remove tick lines outside the plotting area
ax.tick_params(axis="both", which="both", length=0)

# Add a legend with a title
ax.legend(
    title=title_2,
    loc="upper left",
    fontsize=12,
    title_fontsize=12,
    edgecolor="#fdfdfd",
)

# Change the plot background color
ax.set_facecolor("#eaeaf2")

# Show grid with lighter color
ax.grid(True, color="#dcdcdc", linewidth=1.5)

# Change the axis colors
ax.spines["bottom"].set_color("#ffffff")
ax.spines["top"].set_color("#ffffff")
ax.spines["left"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_165.pdf", bbox_inches="tight")
