
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D  # Importing Line2D for creating custom legend items

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Importing numpy for numerical operations

# Data
days = np.arange(1, 8)
city_a_temps = [22.5, 23.1, 23.8, 24.0, 23.5, 24.3, 25.0]
city_b_temps = [18.4, 18.9, 19.3, 19.5, 19.8, 20.4, 20.7]

# Axes Limits and Labels
xlabel_value = "Days"

ylabel_value_1 = "City A Temperature (°C)"
ylabel_value_2 = "City B Temperature (°C)"
ylim_values_1 = [20, 26]
ylim_values_2 = [17, 22]
yticks_values_1 = range(20, 27, 2)
yticks_values_2 = range(17, 23, 2)

# Labels
label_1 = "City A"
label_2 = "City B"
title = "Temperature Trends Over a Week"
suptitle = "Meteorological Data Visualization"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax1 = plt.subplots(figsize=(8, 7))

# City A plot
city_a_color = "#2ca02c"
city_b_color = "#d62728"
(city_a_line,) = ax1.plot(
    days,
    city_a_temps,
    "o-",
    color=city_a_color,
    label=label_1,
    markersize=10,
    linewidth=3,
    mec="black",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color=city_a_color)
ax1.tick_params(
    axis="y", labelcolor=city_a_color, direction="in", rotation=90, labelsize=12
)
ax1.tick_params(
    axis="x",
    direction="in",
    labelsize=12,
)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

# Adding temperatures to the plot for City A
for i, txt in enumerate(city_a_temps):
    ax1.annotate(
        f"{txt}°C",
        (days[i], txt),
        textcoords="offset points",
        xytext=(10, 10),
        ha="center",
        fontsize=12,
    )

# City B plot with a secondary y-axis
ax2 = ax1.twinx()
(city_b_line,) = ax2.plot(
    days,
    city_b_temps,
    "s-",
    color=city_b_color,
    label=label_2,
    markersize=10,
    linewidth=3,
    mec="black",
)
ax2.set_ylabel(ylabel_value_2, color=city_b_color, fontsize=14)
ax2.tick_params(
    axis="y", labelcolor=city_b_color, direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Adding temperatures to the plot for City B
for i, txt in enumerate(city_b_temps):
    ax2.annotate(
        f"{txt}°C",
        (days[i], txt),
        textcoords="offset points",
        xytext=(0, -30),
        ha="center",
        fontsize=12,
    )

# Creating custom legend items
city_a_legend = Line2D([0], [0], color=city_a_color, linewidth=3, label=label_1)
city_b_legend = Line2D([0], [0], color=city_b_color, linewidth=3, label=label_2)

# Adding legends
first_legend = ax1.legend(
    handles=[city_a_legend, city_b_legend],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)  # Add the first legend manually

# ===================
# Part 4: Saving Output
# ===================
plt.title(title, fontsize=16)
plt.suptitle(suptitle, fontsize=18)
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_171.pdf", bbox_inches="tight")
